ScriptName SuitUp:QuestScript Extends Quest

Actor Property PlayerRef Mandatory Const Auto

Perk Property _su_handlerperk Mandatory Const Auto
{ This holds effects as well as notifications. }
GameplayOption Property _su_enabledGPO Mandatory Const Auto
{ 0 is enabled, 1 is disabled }

Function PerkHandler()
    ;Wait until we are out of menu to avoid clogging up VM
    ;Utility.Wait(0.2)
    Utility.Wait(0.1)
    If _su_enabledGPO.GetValue() == 0
        If  !PlayerRef.HasPerk(_su_handlerperk)
            PlayerRef.AddPerk(_su_handlerperk)
            Debug.Notification("Suit Up enabled.")
        EndIf
    ElseIf _su_enabledGPO.GetValue() == 1
        If  PlayerRef.HasPerk(_su_handlerperk)
            PlayerRef.RemovePerk(_su_handlerperk)
            Debug.Notification("Suit Up disabled.")
        EndIf
    EndIf
EndFunction

Event OnQuestInit()
	StartTimer(7)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        PlayerRef.AddPerk(_su_handlerperk)
        Debug.Notification("Suit Up started.")
        RegisterForGameplayOptionChangedEvent()
        GoToState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    PerkHandler()
EndEvent